# 03.. Tabelle principali della base di dati di GAzie

*   [102.1   Tabella «aliiva»](#alliva)

*   [102.2   Tabella «pagame»](#pagame)

*   [102.3   Tabelle «clfoco» e «anagra»](#anagra)

*   [102.4   Tabella «caucon»](#almltitle6489)

*   [102.5   Tabelle «tesmov», «rigmoc» e «rigmoi»](#almltitle6490)

*   [102.6   Tabelle «artico» e «catmer»](#almltitle6491)

*   [102.7   Tabelle «agenti» e «provvigioni»](#almltitle6492)

*   [102.8   Tabella «caumag»](#almltitle6493)

*   [102.9   Tabella «movmag»](#almltitle6494)

*   [102.10   Tabella «banapp»](#almltitle6495)

*   [102.11   Tabella «imball»](#almltitle6496)

*   [102.12   Tabella «portos»](#almltitle6497)

*   [102.13   Tabella «spediz»](#almltitle6498)

*   [102.14   Tabella «vettor»](#almltitle6499)

*   [102.15   Tabella «body_text»](#almltitle6500)

*   [102.16   Tabelle «tesdoc», «rigdoc»](#almltitle6501)

*   [102.17   Tabella «effett»](#almltitle6502)

*   [102.18   Tabelle «contract» e «contract_row»](#almltitle6503)

*   [102.19   Tabelle «tesbro» e «rigbro»](#almltitle6504)

*   [102.20   Tabella «aziend»](#almltitle6505)


In questo capitolo si descrivono le tabelle di Gazie, per come risultano da uno studio svolto sulla versione 5.19. Le indicazioni che sono riportate qui vanno però verificate nella pratica, se si intende intervenire direttamente nella loro modifica, tenendo conto anche della dinamicità che contraddistingue questo applicativo.

Le tabella di Gazie sono di due tipi: generali o specifiche per azienda. Per esempio, la tabella __gaz_config__ descrive la configurazione generale dell'applicativo, mentre la tabella __gaz_001artico__ contiene gli articoli di magazzino dell'azienda 001. Nelle sezioni successive, generalmente i nomi delle tabelle sono indicati senza prefisso; per esempio, la tabella __gaz_**nnn**artico__ viene indicata semplicemente con il nome __artico__, mentre __gaz_anagra__ appare solo come __anagra__.

L'ordine con cui vengono descritte le tabelle di Gazie, è quello che dovrebbe facilitarne lo studio, mettendo davanti preferibilmente quelle tabelle che poi vengono richiamate dai contenuti di altre, privilegiando comunque prima la contabilità generale, poi quella di magazzino e infine la gestione dei documenti delle vendite e degli acquisti.

<h2 id="alliva">102.1  Tabella «aliiva»</h2>

La tabella __aliiva__ serve per codificare i vari tipi di IVA utilizzabili nella vendita e negli acquisti. Diverse altre tabelle fanno riferimento a codici IVA contenuti in questa.

![gazie, tabella aliiva](_contenuti/immagini/tabelle/3315.jpg)


<h2 id="pagame">102.2 Tabella «pagame»</h2>

La tabella __pagame__ contiene un elenco di modalità di pagamento delle fatture. Tra le varie colonne presenti, appare __id_bank__, dove potrebbe essere annotato un conto corrente bancario per l'accredito in corrispondenza dell'uso di una certa causale. Tale codice si riferisce alla tabella __clfoco__, la quale, tra le altre cose, contiene anche le informazioni sui conti correnti utilizzati.

[![gazie, tabella pagame](_contenuti/immagini/tabelle/3316.jpg "gazie_tabella_pagame.jpg")](http://a2.pluto.it/a2/3316.jpg)

<h2 id="anagra">102.3 Tabelle «clfoco» e «anagra»</h2>

La tabella più importante di Gazie è quella denominata __clfoco__. Questa sigla significa letteralmente «clienti, fornitori e conti». In pratica, si tratta del piano dei conti, nel quale trovano posto anche clienti, fornitori e conti correnti bancari.


[![gazie, tabella clfoco, 1 di 2](_contenuti/immagini/tabelle/3317.jpg "gazie_tabella_clfoco_1_di_2.jpg")](http://a2.pluto.it/a2/3317.jpg)

[![gazie, tabella clfoco, 2 di 2](_contenuti/immagini/tabelle/3318.jpg "gazie_tabella_clfoco_2_di_2.jpg")](http://a2.pluto.it/a2/3318.jpg)


Nella tabella, in riferimento ai conti che rappresentano clienti o fornitori, la colonna __codpag__ indica un codice di pagamento relativo alla tabella __pagame__. Per i clienti, la colonna __aliiva__ indica una voce IVA dalla tabella __aliiva__, utile per indicare che quel cliente ha diritto ad acquistare con un'aliquota IVA diversa rispetto a quella applicata normalmente. La colonna __cosric__ (costo o ricavo) permette di annotare un conto di costo o di ricavo, da utilizzare preferibilmente per la registrazione delle fatture relative ai fornitori o ai clienti.
Va osservato che non tutte le informazioni di clienti, fornitori e conti correnti, sono contenute nel piano dei conti; quello che manca si trova in una tabella unica per tutte le aziende, denominata __anagra__.


[![gazie, tabella anagra](_contenuti/immagini/tabelle/3319.jpg "gazie_tabella_anagra.jpg")](http://a2.pluto.it/a2/3319.jpg)

Figura [102.6](#almlanchor18478). Sintesi dei collegamenti tra la tabella __clfoco__ e altre di livello inferiore.

[![Gazie: tabella clfoco: collegamenti](_contenuti/immagini/tabelle/3320.jpg "gazie_tabella_clfoco_collegamenti.jpg")](http://a2.pluto.it/a2/3320.jpg)

## 102.4   <span id="almltitle6489"></span><span id="almlanchor18479"></span>Tabella «caucon»<span id="almlindex15123"></span><span id="almlindex15124"></span>

La tabella __caucon__ raccoglie le causali di contabilità, ovvero le informazioni sulla struttura di alcune scritture. In particolare risultano annotate: la descrizione della causale; il fatto che la registrazione contabile richieda di fornire i dati di un documento di riferimento; il tipo di registro IVA collegato all'operazione; se l'imponibile vada sommato, sottratto o ignorato nel registro IVA; i conti predefiniti e la loro collocazione.

Il codice delle causali contabili è alfanumerico, per facilitarne il riconoscimento, inoltre è possibile definire un massimo di sei conti da proporre automaticamente in fase di inserimento delle scritture contabili.

Alcune causali contabili sono obbligatorie, in quanto utilizzate automaticamente dalla procedura per la registrazione di documenti gestiti internamente. In pratica, le causali di cui dispone Gazie nella prima installazione, vanno utilizzate come sono. Tra le causali obbligatorie si possono osservare quelle con codice __FAI__ e __FAD__, le quali sono identiche, a parte il codice e la descrizione; ciò dipende dal fatto di voler distinguere le registrazioni prodotte a partire da «fatture immediate», in quanto prive di un DDT, rispetto alle «fatture differite», ovvero derivanti da un DDT.


![gazie, tabella caucon, 1 di 2](_contenuti/immagini/tabelle/3321.jpg "gazie_tabella_caucon_1_di_2.jpg")

![gazie, tabella caucon, 2 di 2](_contenuti/immagini/tabelle/3322.jpg "gazie_tabella_caucon_2_di_2.jpg")

Figura [102.9](#almlanchor18482). Schema di funzionamento delle causali contabili obbligatorie per Gazie.


![gazie, tabella caucon, schema](_contenuti/immagini/tabelle/3323.jpg "gazie_tabella_caucon_schema.jpg")


## 102.5   <span id="almltitle6490"></span><span id="almlanchor18483"></span>Tabelle «tesmov», «rigmoc» e «rigmoi»<span id="almlindex15125"></span><span id="almlindex15126"></span><span id="almlindex15127"></span><span id="almlindex15128"></span><span id="almlindex15129"></span><span id="almlindex15130"></span>

Le tabelle __tesmov__, __rigmoc__ e __rigmoi__, vengono usate da Gazie per annotare le registrazioni contabili nella forma della «prima nota». Per la precisione, la tabella __tesmov__ contiene, per ogni riga, le indicazioni generali di una scrittura: data di registrazione, causale, descrizione, dati del documento, registro IVA coinvolto; la tabella __rigmoc__ contiene i dati dei conti coinvolti, assieme agli importi rispettivi, con il riferimento alla registrazione a cui appartengono; la tabella __rigmoi__ contiene i dati degli imponibili e del modo in cui questi devono essere trattati nel registro IVA. Dal contenuto di queste tre tabelle si ottengono il libro giornale, i registri IVA e il partitario dei conti.

Nelle figure successive che descrivono la struttura delle tre tabelle usate per la registrazione della prima nota, i dati inseriti riguardano due scritture di esempio: la prima è un versamento in conto corrente, con prelievo da cassa, utilizzando una causale libera; la seconda è una fattura di vendita a un cliente, utilizzando la causale __FAI__.


![gazie, tabella tesmov](_contenuti/immagini/tabelle/3324.jpg "gazie_tabella_tesmov.jpg")

![gazie, tabelle rigmoc e rigmoi](_contenuti/immagini/tabelle/3325.jpg "gazie_tabelle_rigmoc_e_rigmoi.jpg")


Figura [102.12](#almlanchor18486). Scritture rappresentate nel contenuto di esempio delle tabelle __rigmov__, __rigmoc__ e __rigmoi__.


![gazie, tabelle rigmov, rigmoc e rigmoi, schema di esempio](_contenuti/immagini/tabelle/3326.jpg "gazie_tabelle_rigmov_rigmoc_e_rigmoi_schema_di_esempio.jpg")

Figura [102.13](#almlanchor18487). Sintesi dei collegamenti tra le tabelle usate per annotare le scritture della contabilità generale.

![Gazie: tabelle tesmod, rigmoc e rigmoi: collegamenti](_contenuti/immagini/tabelle/3327.jpg "gazie_tabelle_tesmod_rigmoc_e_rigmoi_collegamenti.jpg")


## 102.6   <span id="almltitle6491"></span><span id="almlanchor18488"></span>Tabelle «artico» e «catmer»<span id="almlindex15131"></span><span id="almlindex15132"></span><span id="almlindex15133"></span><span id="almlindex15134"></span>

Gazie gestisce gli articoli di magazzino, raggruppandoli in «categorie merceologiche»; se anche non si vogliono gestire le categorie, se ne deve definire almeno una, da associare a tutti gli articoli. Per rappresentare gli articoli e le categorie, Gazie utilizza due tabelle, rispettivamente __artico__ e __catmer__.


![gazie, tabella artico, 1 di 2](_contenuti/immagini/tabelle/3328.jpg "gazie_tabella_artico_1_di_2.jpg")


![gazie, tabella artico, 2 di 2](_contenuti/immagini/tabelle/3329.jpg "gazie_tabella_artico_2_di_2.jpg")


![gazie, tabella catmer](_contenuti/immagini/tabelle/3330.jpg "gazie_tabella_catmer.jpg")


Figura [102.17](#almlanchor18492). Sintesi dei collegamenti tra le tabelle usate per catalogare gli articoli di magazzino.


![Gazie: tabelle artico e catmer: collegamenti](_contenuti/immagini/tabelle/3331.jpg "gazie_tabelle_artico_e_catmer_collegamenti.jpg")

## 102.7   <span id="almltitle6492"></span><span id="almlanchor18493"></span>Tabelle «agenti» e «provvigioni»<span id="almlindex15135"></span><span id="almlindex15136"></span><span id="almlindex15137"></span><span id="almlindex15138"></span>

Gli agenti sono persone che si occupano di promuovere le vendite dei prodotti o dei servizi di cui si occupa l'azienda. La loro remunerazione avviene in percentuale sulle vendite di loro competenza. Gazie utilizza due tabelle per le informazioni inerenti gli agenti: una, denominata __agenti__, con la provvigione da applicare in modo predefinito; l'altra, denominata __provvigioni__, con provvigioni specifiche sugli articoli di magazzino o sulle categorie merceologiche. Ma queste informazioni sugli articoli o sulle categorie merceologiche sembrano essere ignorate dalla procedura, la quale applica la sola provvigione predefinita quando l'agente risulta associato a un certo cliente.

Gazie considera gli agenti come fornitori di un servizio, pertanto questi devono essere già stati classificati nella tabella __clfoco__, proprio in qualità di fornitori. Poi, nella tabella __agenti__, si fa riferimento al codice del piano dei conti, per individuare tutti i dati disponibili su di loro.

![gazie, tabelle agenti e provvigioni](_contenuti/immagini/tabelle/3332.jpg "gazie_tabelle_agenti_e_provvigioni.jpg")

Figura [102.19](#almlanchor18495). Sintesi dei collegamenti tra le tabelle usate per classificare gli agenti e le provvigioni.


![Gazie: tabelle agenti e provvigioni: collegamenti](_contenuti/immagini/tabelle/3333.jpg "gazie_tabelle_agenti_e_provvigioni_collegamenti.jpg")

## 102.8   <span id="almltitle6493"></span><span id="almlanchor18496"></span>Tabella «caumag»<span id="almlindex15139"></span><span id="almlindex15140"></span>

La tabella __caumag__ raccoglie le causali di magazzino, ovvero ciò che sintetizza le operazioni di carico e scarico. Le causali predefinite di Gazie, sono quelle sufficienti in un'azienda mercantile.

![gazie, tabella caumag](_contenuti/immagini/tabelle/3334.jpg "gazie_tabella_caumag.jpg")

## 102.9   <span id="almltitle6494"></span><span id="almlanchor18498"></span>Tabella «movmag»<span id="almlindex15141"></span><span id="almlindex15142"></span>

La tabella __movmag__ raccoglie i movimenti di magazzino (carichi e scarichi). Nella tabella ci sono due riferimenti esterni, la cui presenza però non è sempre obbligatoria: il codice del cliente o del fornitore coinvolto nell'operazione e il codice di un documento da cui deriva l'operazione di magazzino. Il codice del cliente o del fornitore riguarda la tabella __clfoco__, mentre quello del documento si riferisce alla tabella __tesdoc__, ma questa viene descritta più avanti, a causa della sua complessità.


![gazie, tabella movmag](_contenuti/immagini/tabelle/3335.jpg "gazie_tabella_movmag.jpg")


## 102.10   <span id="almltitle6495"></span><span id="almlanchor18500"></span>Tabella «banapp»<span id="almlindex15143"></span><span id="almlindex15144"></span>

La tabella __banapp__ elenca le banche di appoggio. Questo elenco non ha riferimenti con i conti correnti che appaiono nel piano dei conti (tabella __clfoco__). La banca di appoggio viene indicata nei documenti della vendita.


![gazie, tabella banapp](_contenuti/immagini/tabelle/3336.jpg "gazie_tabella_banapp.jpg")


## 102.11   <span id="almltitle6496"></span><span id="almlanchor18502"></span>Tabella «imball»<span id="almlindex15145"></span><span id="almlindex15146"></span>

La tabella __imball__ raccoglie un elenco di tipi di imballaggio, con le caratteristiche relative. Non ci sono riferimenti esterni.

![gazie, tabella imball](_contenuti/immagini/tabelle/3337.jpg "gazie_tabella_imball.jpg")


## 102.12   <span id="almltitle6497"></span><span id="almlanchor18504"></span>Tabella «portos»<span id="almlindex15147"></span><span id="almlindex15148"></span>

La tabella __portos__ elenca i tipi di porto o di resa utilizzabili nella compilazione dei documenti della vendita. Non ci sono riferimenti esterni.


![gazie, tabella portos](_contenuti/immagini/tabelle/3338.jpg "gazie_tabella_portos.jpg")

## 102.13   <span id="almltitle6498"></span><span id="almlanchor18506"></span>Tabella «spediz»<span id="almlindex15149"></span><span id="almlindex15150"></span>

La tabella __spediz__ raccoglie un elenco di modalità di spedizione, per la compilazione dei documenti della vendita. Non ci sono riferimenti esterni.


![gazie, tabella spediz](_contenuti/immagini/tabelle/3339.jpg "gazie_tabella_spediz.jpg")


## 102.14   <span id="almltitle6499"></span><span id="almlanchor18508"></span>Tabella «vettor»<span id="almlindex15151"></span><span id="almlindex15152"></span>

La tabella __vettor__ contiene un elenco di vettori per la compilazione dei documenti di accompagnamento delle merci. Questa tabella non ha riferimenti esterni, ma va osservato che se un vettore ci invia una fattura per il servizio di trasporto reso, deve comunque apparire anche tra i fornitori, nella tabella __clfoco__.


![gazie, tabella vettor](_contenuti/immagini/tabelle/3340.jpg "gazie_tabella_vettor.jpg")

## 102.15   <span id="almltitle6500"></span><span id="almlanchor18510"></span>Tabella «body_text»<span id="almlindex15153"></span><span id="almlindex15154"></span>

La tabella __body_text__ è un contenitore di testi di dimensioni relativamente grandi, a collocare all'interno di documenti di vario tipo. In pratica, le tabelle che si usano per rappresentare i documenti della compravendita, della gestione ordini e dei contratti, possono fare riferimento a __body_text__, quando necessitano di un testo abbastanza articolato.

La tabella __body_text__ è composta quindi da un numero identificativo di ogni testo contenuto, del nome della tabella da cui proviene un riferimento e del numero identificativo della voce di tale tabella, oltre al testo.

![gazie, tabella body_text](_contenuti/immagini/tabelle/3341.jpg "gazie_tabella_body_text.jpg")


L'esempio mostrato riporta quattro testi, di cui uno utilizzato dalla tabella __tesdoc__ e gli altri dalla tabella __contract__.

## 102.16   <span id="almltitle6501"></span><span id="almlanchor18512"></span>Tabelle «tesdoc», «rigdoc»<span id="almlindex15155"></span><span id="almlindex15156"></span><span id="almlindex15157"></span><span id="almlindex15158"></span>

Gazie mette tutti i dati dei documenti della compravendita, esclusi gli ordini e la richiesta di preventivi, in un solo «archivio», rappresentato dalle tabelle __tesdoc__ e __rigdoc__, oltre all'ausilio di __body_text__ per l'inclusione di testi significativi ([102.15](#almlanchor18510)). Per esempio, in questo archivio vanno i DDT, le fatture, le note di accredito e di addebito. Gazie ha però un'altra caratteristica importante: oltre ai documenti della vendita, consente eventualmente di catalogare elettronicamente anche quelli degli acquisti, richiedendo comunque un po' di accortezza in più.

I tipi di documenti gestibili in queste tabelle sono definiti attraverso delle sigle precise, gestite internamente dalla procedura, come elencato nello schema successivo. Per interpretare le descrizioni, va comunque considerato che per «cliente» o «fornitore» si intende chi in quel momento intrattiene quel tipo di rapporto con noi; per esempio, un fornitore abituale, in certe circostanze può divenire cliente, e lo stesso vale per il caso inverso.

<table id="almlanchor18513">

<tbody>

<tr>

<td>

<div class="object">

<table class="table"><colgroup><col class="widthpixel308"><col class="widthpixel1306"></colgroup>

<thead class="minimalborder">

<tr>

<td class="noborder">Sigla</td>

<td class="noborder">Tipo di documento</td>

</tr>

</thead>

<tbody class="noborder">

<tr>

<td class="noborder">DDT</td>

<td class="noborder">DDT di vendita a cliente</td>

</tr>

<tr>

<td class="noborder">DDR</td>

<td class="noborder">DDT di reso a fornitore</td>

</tr>

<tr>

<td class="noborder">DDL</td>

<td class="noborder">DDT di invio in lavorazione</td>

</tr>

<tr>

<td class="noborder">ADT</td>

<td class="noborder">DDT di acquisto da fornitore</td>

</tr>

<tr>

<td class="noborder">FAI</td>

<td class="noborder">fattura immediata (senza DDT) di vendita a cliente</td>

</tr>

<tr>

<td class="noborder">FAD</td>

<td class="noborder">fattura differita (successiva al DDT) di vendita a cliente</td>

</tr>

<tr>

<td class="noborder">FNC</td>

<td class="noborder">nota di accredito a cliente</td>

</tr>

<tr>

<td class="noborder">FND</td>

<td class="noborder">nota di addebito a cliente</td>

</tr>

<tr>

<td class="noborder">FAP</td>

<td class="noborder">parcella a cliente</td>

</tr>

<tr>

<td class="noborder">AFA</td>

<td class="noborder">fattura di acquisto da fornitore</td>

</tr>

<tr>

<td class="noborder">AFC</td>

<td class="noborder">nota di accredito da fornitore</td>

</tr>

</tbody>

</table>


Nella gestione delle vendite, il DDT da cui poi viene generata la fattura differita, non produce registrazioni doppie nell'archivio, in quanto si trasforma, dal tipo __DDT__ al tipo __FAD__. Se poi la fattura differita viene cancellata, il documento archiviato torna a essere un DDT puro e semplice.

Negli acquisti questo procedimento viene meno: se si inserisce un DDT di acquisto, significa probabilmente che non si intende aggiungere poi anche la fattura, o viceversa. Infatti, se si inserissero entrambi i documenti, si otterrebbero registrazioni duplicate in contabilità di magazzino.

Le informazioni complessive sul documento archiviato sono contenute nella tabella __tesdoc__, la quale contiene molti riferimenti esterni che in generale descrivono le condizioni di vendita o di acquisto e i collegamenti con la contabilità di magazzino e con la contabilità generale.


![gazie, tabella tesdoc, 1 di 3](_contenuti/immagini/tabelle/3342.jpg "gazie_tabella_tesdoc_1_di_3.jpg")


![gazie, tabella tesdoc, 2 di 3](_contenuti/immagini/tabelle/3343.jpg "gazie_tabella_tesdoc_2_di_3.jpg")


![gazie, tabella tesdoc, 3 di 3](_contenuti/immagini/tabelle/3344.jpg "gazie_tabella_tesdoc_3_di_3.jpg")

Nell'esempio appena mostrato, viene messa in evidenza la numerazione dei DDT di vendita e delle fatture differite. Per la precisione, il primo documento è un DDT non ancora fatturato; poi, il sesto e il settimo documento mostrano una sola fattura differita, la numero 25, contenente il riferimento a due DDT, il numero 12 e il numero 13\. La stessa fattura differita numero 25, pari al sesto e settimo documento della tabella, prevede un tipo di regolamento attraverso l'emissione di un effetto: osservando la colonna __geneff__ si vede che questo effetto è già stato generato.


Figura [102.32](#almlanchor18517). Sintesi dei collegamenti contenuti nella tabella __tesdoc__.


![Gazie: tabella tesdoc: collegamenti](_contenuti/immagini/tabelle/3345.jpg "gazie_tabella_tesdoc_collegamenti.jpg")

Osservando i collegamenti contenuti nella tabella __tesdoc__, si può notare che manca un riferimento ai movimenti di magazzino. Infatti, Gazie gestisce i movimenti di magazzino per singolo articolo; pertanto, questo riferimento si trova invece nella tabella __rigdoc__. La tabella __rigdoc__ contiene quindi l'elenco delle righe del corpo dei documenti sintetizzati invece in __tesdoc__. Naturalmente, la tabella __rigdoc__ deve specificare, per ogni riga, a quale documento appartiene.

Nella tabella __rigdoc__, ogni «rigo» deve essere qualificato per tipo. Ciò appare poi nella colonna __tiprig__ e nella figura successiva è anche chiarito in che modo questo deve essere interpretato.


![gazie, tabella rigdoc](_contenuti/immagini/tabelle/3346.jpg "gazie_tabella_rigdoc.jpg")


Nell'esempio si può osservare che il primo documento (secondo l'ordine attribuito nella tabella __tesdoc__) contiene due articoli e che il terzo contiene tre componenti, costituiti da un articolo, una descrizione semplice e una descrizione testuale più articolata: la descrizione corrispondente al rigo di tipo «6», è però contenuta effettivamente nella tabella __body_text__.


Figura [102.34](#almlanchor18519). Sintesi dei collegamenti contenuti nella tabella __rigdoc__.



![Gazie: tabella rigdoc: collegamenti](_contenuti/immagini/tabelle/3347.jpg "gazie_tabella_rigdoc_collegamenti.jpg")


## 102.17   <span id="almltitle6502"></span><span id="almlanchor18520"></span>Tabella «effett»<span id="almlindex15159"></span><span id="almlindex15160"></span>

La tabella __effett__ raccoglie gli effetti attivi prodotti automaticamente dalle fatture di vendita che ne prevedono l'emissione, o inseriti manualmente, ma sempre in riferimento a fatture emesse. Si prevedono solo due tipi di effetto: ricevute bancarie o RiBa e cambiali tratte. Ogni effetto annotato in questa tabella ha poi un suo percorso: inizialmente l'effetto si considera solo emesso e stampato; la fase successiva richiede l'emissione della distinta effetti oppure del file RiBa; alla fine l'effetto può essere contabilizzato in contabilità generale, annotando direttamente la sua presentazione in banca per l'incasso.

Nella figura successiva si vedono tre effetti, due dei quali inseriti manualmente. L'ultimo effetto riguarda la fattura 25, già apparsa nell'esempio della tabella __tesdoc__; questa fattura è ottenuta a partire da due DDT di vendita, pertanto nella tabella __tesdoc__ è descritta dalle righe sei e sette, mentre nella colonna __id_doc__ della tabella __effett__ appare il riferimento all'ultima di queste righe originali: la numero sette.


![gazie, tabella effett 1/2](_contenuti/immagini/tabelle/3348.jpg "gazie_tabella_effett_1_2.jpg")


![gazie, tabella effett 2/2](_contenuti/immagini/tabelle/3349.jpg "gazie_tabella_effett_2_2.jpg")

## 102.18   <span id="almltitle6503"></span><span id="almlanchor18523"></span>Tabelle «contract» e «contract_row»<span id="almlindex15161"></span><span id="almlindex15162"></span><span id="almlindex15163"></span><span id="almlindex15164"></span>

Le tabelle __contract__ e __contract_row__, assieme a __body_text__ che però viene usata anche in altre occasioni, raccolgono i contratti per la fornitura periodica di prodotti o servizi. Da questi contratti si possono generare poi delle fatture o delle ricevute di pagamento avvenuto, in base alla configurazione dei contratti stessi.

La tabella __contract__ definisce i contratti in forma complessiva, avvalendosi di __body_text__ per conservare il testo effettivo del contratto. La tabella __contract_row__, invece, viene usata per degli addebiti particolari, la cui presenza non è strettamente necessaria per l'esistenza del contratto. Negli esempi che appaiono nelle figure successive, solo il primo contratto utilizza delle righe nella tabella __contract_row__.


![gazie, tabella contract, 1 di 2](_contenuti/immagini/tabelle/3350.jpg "gazie_tabella_contract_1_di_2.jpg")


![gazie, tabella contract, 2 di 2](_contenuti/immagini/tabelle/3351.jpg "gazie_tabella_contract_2_di_2.jpg")


![gazie, tabella contract_raw](_contenuti/immagini/tabelle/3352.jpg "gazie_tabella_contract_raw.jpg")


## 102.19   <span id="almltitle6504"></span><span id="almlanchor18527"></span>Tabelle «tesbro» e «rigbro»<span id="almlindex15165"></span><span id="almlindex15166"></span><span id="almlindex15167"></span><span id="almlindex15168"></span>

Gazie gestisce preventivi e ordini, dove le conferme d'ordine fatte ai clienti possono produrre automaticamente i DDT o le fatture di vendita. Tutto questo viene archiviato nelle tabelle __tesbro__ e __rigbro__, in modo analogo a quanto avviene per i «documenti» (__tesdoc__ e __rigdoc__). Anche in questo caso ci possono essere contenuti testuali nel corpo di preventivi e ordini, appoggiati alla tabella __body_text__.

![gazie, tabella tesbro, 1 di 3](_contenuti/immagini/tabelle/3353.jpg "gazie_tabella_tesbro_1_di_3.jpg")


![gazie, tabella tesbro, 2 di 3](_contenuti/immagini/tabelle/3354.jpg "gazie_tabella_tesbro_2_di_3.jpg")


![gazie, tabella tesbro, 3 di 3](_contenuti/immagini/tabelle/3355.jpg "gazie_tabella_tesbro_3_di_3.jpg")


![gazie, tabella rigbro](_contenuti/immagini/tabelle/3356.jpg "gazie_tabella_rigbro.jpg")

## 102.20   <span id="almltitle6505"></span><span id="almlanchor18532"></span>Tabella «aziend»<span id="almlindex15169"></span><span id="almlindex15170"></span>

La tabella __aziend__ che è unica per tutta la base di dati usata da Gazie, descrive la configurazione generale delle aziende gestite. Per ogni azienda, poi, Gazie utilizza una copia distinta di tabelle, come descritto inizialmente nel capitolo. Nelle figure successive si ipotizza il contenuto della tabella __aziend__ per cinque aziende distinte.



[![gazie, tabella aziend, 1 di 5](_contenuti/immagini/tabelle/3357.jpg "gazie_tabella_aziend_1_di_5.jpg")](http://a2.pluto.it/a2/3357.jpg)




[![gazie, tabella aziend, 2 di 5](_contenuti/immagini/tabelle/3358.jpg "gazie_tabella_aziend_2_di_5.jpg")](http://a2.pluto.it/a2/3358.jpg)


[![gazie, tabella aziend, 3 di 5](_contenuti/immagini/tabelle/3359.jpg "gazie_tabella_aziend_3_di_5.jpg")](http://a2.pluto.it/a2/3359.jpg)


![gazie, tabella aziend, 4 di 5](_contenuti/immagini/tabelle/3360.jpg "gazie_tabella_aziend_4_di_5.jpg")

![gazie, tabella aziend, 5 di 5](_contenuti/immagini/tabelle/3361.jpg "gazie_tabella_aziend_5_di_5.jpg")

*2013.11.11 --- _Copyright © Daniele Giacomini -- appunti2@gmail.com __[http://informaticalibera.net](http://informaticalibera.net/)__*
